function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 333);

T = World_Economy_Cartel_cheaters.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(283) = (T(134)*(exp(y(31))*(exp(y(31))+exp(y(33)))+exp(y(31))*exp(y(31))-(exp(y(31))*exp(y(31))+exp(y(31))*exp(y(31))))-(exp(y(31))*(exp(y(31))+exp(y(33)))-exp(y(31))*exp(y(31)))*(exp(y(31))*(exp(y(31))+exp(y(33)))+exp(y(31))*(exp(y(31))+exp(y(33)))))/(T(134)*T(134));
T(284) = exp(y(33))*(exp(y(31))+exp(y(33)))+exp(y(33))*(exp(y(31))+exp(y(33)));
T(285) = (T(134)*exp(y(31))*exp(y(33))-(exp(y(31))*(exp(y(31))+exp(y(33)))-exp(y(31))*exp(y(31)))*T(284))/(T(134)*T(134));
T(286) = (T(134)*(-(exp(y(31))*exp(y(33))))-(-(exp(y(31))*exp(y(33))))*T(284))/(T(134)*T(134));
T(287) = (T(134)*(-(exp(y(31))*exp(y(33))))-(-(exp(y(31))*exp(y(33))))*(exp(y(31))*(exp(y(31))+exp(y(33)))+exp(y(31))*(exp(y(31))+exp(y(33)))))/(T(134)*T(134));
T(288) = (T(134)*(exp(y(33))*(exp(y(31))+exp(y(33)))+exp(y(33))*exp(y(33))-(exp(y(33))*exp(y(33))+exp(y(33))*exp(y(33))))-(exp(y(33))*(exp(y(31))+exp(y(33)))-exp(y(33))*exp(y(33)))*T(284))/(T(134)*T(134));
T(289) = (T(138)*(T(32)*(T(32)+exp(y(35)))+T(32)*T(32)-(T(32)*T(32)+T(32)*T(32)))-(T(32)*(T(32)+exp(y(35)))-T(32)*T(32))*(T(32)*(T(32)+exp(y(35)))+T(32)*(T(32)+exp(y(35)))))/(T(138)*T(138));
T(290) = exp(y(35))*(T(32)+exp(y(35)))+exp(y(35))*(T(32)+exp(y(35)));
T(291) = (T(138)*T(32)*exp(y(35))-(T(32)*(T(32)+exp(y(35)))-T(32)*T(32))*T(290))/(T(138)*T(138));
T(292) = (T(138)*(-(T(32)*exp(y(35))))-(-(T(32)*exp(y(35))))*T(290))/(T(138)*T(138));
T(293) = (T(138)*(-(T(32)*exp(y(35))))-(-(T(32)*exp(y(35))))*(T(32)*(T(32)+exp(y(35)))+T(32)*(T(32)+exp(y(35)))))/(T(138)*T(138));
T(294) = (T(138)*(exp(y(35))*(T(32)+exp(y(35)))+exp(y(35))*exp(y(35))-(exp(y(35))*exp(y(35))+exp(y(35))*exp(y(35))))-(exp(y(35))*(T(32)+exp(y(35)))-exp(y(35))*exp(y(35)))*T(290))/(T(138)*T(138));
T(295) = T(45)+T(61)+params(23)*y(122)*exp(y(38))*params(6)*params(5)*params(5)*exp(params(5)*y(45));
T(296) = T(268)+T(267)+params(23)*y(122)*exp(y(39))*params(6)*params(5)*exp(params(5)*(y(43)-y(117)))*(-params(5));
T(297) = getPowerDeriv(T(9),T(10),3);
T(298) = T(180)+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),params(3),2);
T(299) = T(5)*T(298);
T(300) = T(172)+T(171)+exp(y(52))*(T(170)+exp(y(52))*exp(y(52))*getPowerDeriv(exp(y(52)),T(11),3));
T(301) = y(71)*(-(T(94)*T(19)*T(16)*exp(T(1)*y(59))*(1-params(11))*params(3)*T(172)+T(5)*T(19)*T(96)*exp(T(1)*y(59))*(1-params(11))*params(3)*T(172)))+y(70)*(-(T(98)*T(3)*T(16)*exp(T(1)*y(59))*(1-params(11))*(1-params(3))*T(172)+T(17)*T(3)*T(96)*exp(T(1)*y(59))*(1-params(11))*(1-params(3))*T(172)));
T(302) = y(71)*(-(T(5)*T(19)*T(16)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(59))*T(172)))+y(70)*(-(T(17)*T(3)*T(16)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(59))*T(172)));
T(303) = T(183)+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),params(3)-1,2);
T(304) = y(71)*(-(T(5)*(T(16)*T(65)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(59))*T(183)+T(19)*T(65)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(59))*T(95)*T(181))))+y(70)*(-(T(17)*(T(16)*T(65)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(59))*T(180)+T(3)*T(65)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(59))*T(95)*T(181))));
T(305) = y(71)*(-(T(94)*T(19)*T(66)*T(96)+T(19)*T(16)*T(66)*T(218)+T(94)*T(19)*T(66)*T(96)+T(5)*T(19)*T(66)*T(219)))+y(70)*(-(T(98)*T(3)*T(67)*T(96)+T(17)*T(3)*T(67)*T(219)+T(98)*T(3)*T(67)*T(96)+T(3)*T(16)*T(67)*T(223)));
T(306) = y(71)*(-(T(94)*T(19)*T(16)*T(65)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(59))+T(5)*T(19)*T(96)*T(65)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(59))))+y(70)*(-(T(17)*T(3)*T(96)*T(65)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(59))+T(98)*T(3)*T(16)*T(65)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(59))));
T(307) = y(71)*(-(T(5)*T(19)*T(16)*T(65)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(59))))+y(70)*(-(T(17)*T(3)*T(16)*T(65)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(59))));
T(308) = getPowerDeriv(T(76),T(10),3);
T(309) = T(177)+exp(y(111))*exp(y(111))*getPowerDeriv(exp(y(111)),T(11),2);
T(310) = (1-params(11))*(1-params(3))*exp(T(1)*y(116))*T(309);
T(311) = T(196)+T(195)+T(20)*(T(194)+T(20)*T(20)*getPowerDeriv(T(20),params(3),3));
T(312) = getPowerDeriv(T(72),T(1),3);
T(313) = getPowerDeriv(T(72),T(13),3);
T(314) = T(69)*T(196)*T(69)*T(70)*T(199)+T(82)*T(69)*T(311)+T(69)*T(196)*T(69)*T(70)*T(199)+T(69)*T(70)*(T(69)*T(196)*T(199)+T(69)*T(70)*T(69)*T(70)*T(313));
T(315) = T(69)*T(196)*T(199)*T(71)*T(235)+T(82)*T(196)*T(235)+T(69)*T(70)*T(199)*T(70)*T(235)+T(69)*T(70)*(T(199)*T(70)*T(235)+T(69)*T(70)*T(71)*T(235)*T(313));
T(316) = T(235)+exp(y(112))*exp(y(112))*getPowerDeriv(exp(y(112)),1-params(3),2);
T(317) = T(70)*T(235)*T(199)*T(71)*T(235)+T(82)*T(70)*T(316)+T(70)*T(235)*T(199)*T(71)*T(235)+T(69)*T(70)*(T(71)*T(235)*T(71)*T(235)*T(313)+T(199)*T(71)*T(316));
T(318) = getPowerDeriv(T(6),T(13),3);
T(319) = T(94)*T(180)*T(181)*T(186)+T(95)*T(94)*T(298)+T(94)*T(180)*T(181)*T(186)+T(3)*T(94)*(T(186)*T(299)+T(181)*T(181)*T(318));
T(320) = getPowerDeriv(T(6),T(1),3);
T(321) = getPowerDeriv(T(27),(-params(15)),2);
T(322) = T(206)*(-(params(9)*(T(204)+exp(y(19))*exp(y(19))*getPowerDeriv(exp(y(19)),1+params(8),2))/(1+params(8))))+T(205)*T(205)*T(321);
T(323) = T(28)*exp(y(20))*T(206)+T(28)*exp(y(20))*T(206);
T(324) = getPowerDeriv(T(25),(-params(15)),3);
T(325) = T(213)*T(89)*T(214)+T(90)*(-(params(9)*(T(212)+T(211)+T(4)*(T(210)+T(4)*T(4)*getPowerDeriv(T(4),1+params(8),3)))/(1+params(8))))+T(213)*T(89)*T(214)+T(89)*(T(213)*T(214)+T(89)*T(89)*T(324));
T(326) = T(218)+T(217)+T(4)*(T(216)+T(4)*T(4)*getPowerDeriv(T(4),1-params(3),3));
T(327) = T(3)*T(218)*T(3)*T(94)*T(186)+T(95)*T(3)*T(326)+T(3)*T(218)*T(3)*T(94)*T(186)+T(3)*T(94)*(T(186)*T(3)*T(218)+T(3)*T(94)*T(3)*T(94)*T(318));
T(328) = getPowerDeriv(T(102),(-params(15)),2);
T(329) = params(1)*(T(241)*(-(params(9)*(T(239)+exp(y(112))*exp(y(112))*getPowerDeriv(exp(y(112)),1+params(8),2))/(1+params(8))))+T(240)*T(240)*T(328));
T(330) = y(71)*(-(T(94)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(59))+T(5)*T(19)*T(96)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(59))));
T(331) = y(70)*(-(T(98)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(59))+T(17)*T(3)*T(96)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(59))));
T(332) = T(248)+exp(y(55))*exp(y(55))*T(214)+exp(y(55))*(exp(y(55))*T(214)+exp(y(55))*exp(y(55))*T(324));
T(333) = getPowerDeriv(exp(y(67)-y(60)),params(5)-1,3);

end
